/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.items.ESItems;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.PulseCircuitTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class PulseCircuit
extends AbstractCircuit {
    public final Edge edge;

    public PulseCircuit(Edge edge) {
        super("pulse_" + edge.name + "_circuit");
        this.edge = edge;
    }

    @Override
    public boolean useInput(CircuitTileEntity.Orient or) {
        return or == CircuitTileEntity.Orient.BACK;
    }

    @Override
    public float getOutput(float in0, float in1, float in2, CircuitTileEntity te) {
        if (te instanceof PulseCircuitTileEntity) {
            return ((PulseCircuitTileEntity)te).currentOutput(0);
        }
        return 0.0f;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (ESConfig.isWrench(playerIn.m_21120_(hand))) {
            super.m_6227_(state, worldIn, pos, playerIn, hand, hit);
        } else {
            BlockEntity te;
            if (playerIn.m_21120_(hand).m_41720_() == ESItems.circuitWrench) {
                return InteractionResult.PASS;
            }
            if (!worldIn.f_46443_ && (te = worldIn.m_7702_(pos)) instanceof PulseCircuitTileEntity) {
                PulseCircuitTileEntity tte = (PulseCircuitTileEntity)te;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)tte, buf -> CircuitContainer.encodeData(buf, te.m_58899_(), tte.settingStrDuration));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PulseCircuitTileEntity(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.pulse_circuit_" + this.edge.name));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ITickableTileEntity.createTicker(type, PulseCircuitTileEntity.TYPE);
    }

    public static enum Edge {
        RISING(true, false, "rising"),
        FALLING(false, true, "falling"),
        DUAL(true, true, "dual");

        public final String name;
        public final boolean start;
        public final boolean end;

        private Edge(boolean start, boolean end, String name) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.name;
        }
    }
}

